/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.cpsw;

import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.SingleInstanceFactory;
import ibm.nways.jdm8260.DecoderException;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class RowMultSstDecoder {
    public static final int IUB_ASN_TYPE_UNSET = 0;
    public static final int IUB_ASN_BOOLEAN = 1;
    public static final int IUB_ASN_INTEGER = 2;
    public static final int IUB_ASN_U_INTEGER = 7;
    public static final int IUB_ASN_BIT_STR = 3;
    public static final int IUB_ASN_OCTET_STR = 4;
    public static final int IUB_ASN_NULL = 5;
    public static final int IUB_ASN_OBJECT_ID = 6;
    public static final int IUB_ASN_SEQUENCE = 48;
    public static final int IUB_ASN_IPADDRESS = 64;
    public static final int IUB_ASN_TIMETICKS = 67;
    private static final boolean debugOIDConversion = false;
    private static final boolean debugDecodeItem = false;
    private static final boolean debugDecodeLength = false;
    private static final boolean debugDecodeSuffix = true;
    private static final boolean debugDecodeValue = true;
    private static final Serializable NOT_SUPPORTED_VALUE = (Serializable)SingleInstanceFactory.getInstance("ibm.nways.jdm.common.NotSupported");
    private static final Serializable TIMEOUT_VALUE = (Serializable)SingleInstanceFactory.getInstance("ibm.nways.jdm.common.Timeout");
    private byte[] values;
    private String[] containment;
    private String[] indexesIds;
    private String[][] attrIds;
    private int[][] attrNums;
    private int infoNumber;
    private ModelInfo info;
    private int containmentIndex;
    private final Vector result = new Vector();
    private static final Hashtable mappingTable = new Hashtable();
    private static final String IP_STR = "IP";
    private static final String DS_STR = "DS";
    static /* synthetic */ Class class$ibm$nways$cpsw$RowMultSstDecoder;

    public final ModelInfo[] decode(byte[] byArray, int n, int n2, String[] stringArray, String[] stringArray2, String[][] stringArray3, int[][] nArray) {
        int n3;
        ModelInfo[] modelInfoArray;
        String string = "decode";
        if (byArray == null) {
            return RowMultSstDecoder.returnFullTimeout(stringArray3, stringArray2);
        }
        if (byArray.length == 0) {
            return null;
        }
        this.result.removeAllElements();
        this.values = byArray;
        this.containment = stringArray;
        this.indexesIds = stringArray2;
        this.attrIds = stringArray3;
        this.attrNums = nArray;
        int n4 = 0;
        try {
            modelInfoArray = this.decodeItem(n4, 48);
            n4 = modelInfoArray.itemDataIndex;
            modelInfoArray = this.decodeItem(n4, 67);
            n4 = modelInfoArray.nextItemIndex;
            modelInfoArray = this.decodeItem(n4, 48);
            n3 = modelInfoArray.itemDataLength;
            n4 = modelInfoArray.itemDataIndex;
            while (n3 > 0) {
                modelInfoArray = this.decodeContainment(n4);
                n3 -= modelInfoArray.itemLength;
                n4 = modelInfoArray.nextItemIndex;
            }
        }
        catch (Exception exception) {
            RAS.logException(4, 1015, this, string, exception);
            return null;
        }
        this.values = null;
        if (this.result.size() == 0) {
            return null;
        }
        modelInfoArray = new ModelInfo[this.result.size()];
        n3 = 0;
        while (n3 < this.result.size()) {
            modelInfoArray[n3] = (ModelInfo)this.result.elementAt(n3);
            RowMultSstDecoder.checkForNotSupportedValues(modelInfoArray[n3], stringArray3);
            modelInfoArray[n3].add("Panel.SsValues");
            ++n3;
        }
        this.result.removeAllElements();
        return modelInfoArray;
    }

    public static void checkForNotSupportedValues(ModelInfo modelInfo, String[][] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < stringArray[n].length) {
                if (modelInfo.get(stringArray[n][n2]) == null) {
                    modelInfo.add(stringArray[n][n2], NOT_SUPPORTED_VALUE);
                }
                ++n2;
            }
            ++n;
        }
    }

    public static ModelInfo[] returnFullTimeout(String[][] stringArray, String[] stringArray2) {
        int n;
        ModelInfo modelInfo = new ModelInfo();
        int n2 = 0;
        while (n2 < stringArray.length) {
            n = 0;
            while (n < stringArray[n2].length) {
                modelInfo.add(stringArray[n2][n], TIMEOUT_VALUE);
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < stringArray2.length) {
            modelInfo.add(stringArray2[n], TIMEOUT_VALUE);
            ++n;
        }
        modelInfo.timeoutDetected = true;
        ModelInfo[] modelInfoArray = new ModelInfo[]{modelInfo};
        return modelInfoArray;
    }

    private final DecodeRetValue decodeItem(int n, int n2) throws DecoderException {
        String string = "decodeItem";
        DecodeRetValue decodeRetValue = this.decodeLength(n + 1, this.values[n] & 0xFF);
        DecodeRetValue decodeRetValue2 = new DecodeRetValue();
        decodeRetValue2.itemDataLength = decodeRetValue.itemLength;
        decodeRetValue2.itemLength = decodeRetValue.itemDataLength + decodeRetValue.itemLength + 1;
        decodeRetValue2.itemDataIndex = n + 1 + decodeRetValue.itemDataLength;
        decodeRetValue2.nextItemIndex = n + decodeRetValue2.itemLength;
        if ((this.values[n] & 0xFF) != n2) {
            throw new DecoderException("Mismatched syntax. Expected " + n2 + " and found " + (this.values[n] & 0xFF));
        }
        return decodeRetValue2;
    }

    private final DecodeRetValue decodeItem(int n) throws DecoderException {
        int n2 = this.values[n] & 0xFF;
        DecodeRetValue decodeRetValue = this.decodeItem(n, n2);
        decodeRetValue.syntax = n2;
        return decodeRetValue;
    }

    private final DecodeRetValue decodeLength(int n, int n2) throws DecoderException {
        int n3;
        int n4;
        String string = "decodeLength";
        DecodeRetValue decodeRetValue = new DecodeRetValue();
        int n5 = this.values[n] & 0xFF;
        if ((n5 & 0x80) != 0) {
            n4 = n5 & 0xFFFFFF7F;
            n3 = RowMultSstDecoder.computeIntegerValue(this.values, n + 1, n4);
            ++n4;
        } else {
            n3 = n5;
            n4 = 1;
        }
        decodeRetValue.itemLength = n3;
        decodeRetValue.itemDataLength = n4;
        if (n3 == 0 && n2 != 5 && n2 != 6 && n2 != 4) {
            throw new DecoderException("Zero length item found with invalid syntax " + n2);
        }
        if (n3 < 0) {
            throw new DecoderException("Negative length found: " + n3);
        }
        return decodeRetValue;
    }

    private final int findContainmentOID(String string) {
        int n = 0;
        while (n < this.containment.length) {
            if (this.containment[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private final DecodeRetValue decodeContainment(int n) throws DecoderException {
        DecodeRetValue decodeRetValue = this.decodeItem(n, 48);
        DecodeRetValue decodeRetValue2 = new DecodeRetValue();
        decodeRetValue2.itemLength = decodeRetValue.itemLength;
        decodeRetValue2.nextItemIndex = decodeRetValue.nextItemIndex;
        decodeRetValue = this.decodeItem(decodeRetValue.itemDataIndex, 6);
        String string = RowMultSstDecoder.convertAsn1ObjectIdToDecimalString(this.values, decodeRetValue.itemDataIndex, decodeRetValue.itemDataLength);
        this.containmentIndex = this.findContainmentOID(string);
        if (this.containmentIndex != -1) {
            decodeRetValue = this.decodeItem(decodeRetValue.nextItemIndex, 48);
            n = decodeRetValue.itemDataIndex;
            int n2 = decodeRetValue.itemDataLength;
            this.infoNumber = 0;
            while (n2 > 0) {
                decodeRetValue = this.decodeBlock(n, string);
                n2 -= decodeRetValue.itemLength;
                n = decodeRetValue.nextItemIndex;
                ++this.infoNumber;
            }
        }
        return decodeRetValue2;
    }

    private final DecodeRetValue decodeBlock(int n, String string) throws DecoderException {
        DecodeRetValue decodeRetValue = this.decodeItem(n, 48);
        DecodeRetValue decodeRetValue2 = new DecodeRetValue();
        decodeRetValue2.itemLength = decodeRetValue.itemLength;
        decodeRetValue2.nextItemIndex = decodeRetValue.nextItemIndex;
        n = decodeRetValue.itemDataIndex;
        boolean bl = false;
        if (this.result.size() > this.infoNumber) {
            this.info = (ModelInfo)this.result.elementAt(this.infoNumber);
        } else {
            this.info = new ModelInfo();
            bl = true;
        }
        decodeRetValue = this.decodeSuffix(n);
        String string2 = decodeRetValue.suffix;
        n = decodeRetValue.nextItemIndex;
        decodeRetValue = this.decodeItem(n, 48);
        n = decodeRetValue.itemDataIndex;
        int n2 = decodeRetValue.itemDataLength;
        while (n2 > 0) {
            decodeRetValue = this.decodeValue(n, string, string2);
            n2 -= decodeRetValue.itemLength;
            n = decodeRetValue.nextItemIndex;
        }
        if (bl) {
            this.result.addElement(this.info);
        }
        this.info = null;
        return decodeRetValue2;
    }

    private final int findAttributeNumber(int n) {
        int n2 = 0;
        while (n2 < this.attrNums[this.containmentIndex].length) {
            if (n == this.attrNums[this.containmentIndex][n2]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private final DecodeRetValue decodeValue(int n, String string, String string2) throws DecoderException {
        String string3 = "decodeValue";
        DecodeRetValue decodeRetValue = this.decodeItem(n, 48);
        DecodeRetValue decodeRetValue2 = new DecodeRetValue();
        decodeRetValue2.nextItemIndex = decodeRetValue.nextItemIndex;
        decodeRetValue2.itemLength = decodeRetValue.itemLength;
        n = decodeRetValue.itemDataIndex;
        decodeRetValue = this.decodeItem(n, 2);
        int n2 = RowMultSstDecoder.computeIntegerValue(this.values, decodeRetValue.itemDataIndex, decodeRetValue.itemDataLength);
        int n3 = this.findAttributeNumber(n2);
        decodeRetValue2.suffix = String.valueOf(n2);
        if (n3 == -1) {
            return decodeRetValue2;
        }
        String string4 = String.valueOf(string) + "." + decodeRetValue2.suffix;
        n = decodeRetValue.nextItemIndex;
        decodeRetValue = this.decodeItem(n);
        Object object = "null";
        switch (decodeRetValue.syntax) {
            case 2: {
                int n4 = RowMultSstDecoder.computeIntegerValue(this.values, decodeRetValue.itemDataIndex, decodeRetValue.itemDataLength);
                object = new Integer(n4);
                break;
            }
            case 64: {
                int n5 = 0;
                n = decodeRetValue.itemDataIndex;
                int n6 = 0;
                while (n6 < decodeRetValue.itemDataLength) {
                    n5 = n5 << 8 | this.values[n++] & 0xFF;
                    ++n6;
                }
                object = new IPAddress(n5);
                break;
            }
            case 4: {
                byte[] byArray = new byte[decodeRetValue.itemDataLength];
                n = decodeRetValue.itemDataIndex;
                int n7 = 0;
                while (n7 < decodeRetValue.itemDataLength) {
                    byArray[n7] = this.values[n++];
                    ++n7;
                }
                object = new OctetString(byArray);
                Object v = mappingTable.get(this.attrIds[this.containmentIndex][n3]);
                if (v == null) break;
                if (v == IP_STR) {
                    object = new IPAddress(((OctetString)object).value, 0);
                    break;
                }
                if (v != DS_STR) break;
                object = ((OctetString)object).toDisplayString();
                break;
            }
            default: {
                throw new DecoderException("Unknown syntax for attribute value: Oid = " + string + "." + decodeRetValue2.suffix + " syntax = " + decodeRetValue.syntax + " suffix = " + string2);
            }
        }
        this.info.add(this.attrIds[this.containmentIndex][n3], (Serializable)object);
        if (RAS.isEnabled(4, 1015)) {
            RAS.trace(4, 1015, this, string3, "Full OID -> " + string4);
            RAS.trace(4, 1015, this, string3, "Syntax   -> " + decodeRetValue.syntax);
            RAS.trace(4, 1015, this, string3, "Value    -> " + object);
        }
        return decodeRetValue2;
    }

    private final DecodeRetValue decodeSuffix(int n) throws DecoderException {
        String string = "decodeSuffix";
        DecodeRetValue decodeRetValue = new DecodeRetValue();
        DecodeRetValue decodeRetValue2 = this.decodeItem(n);
        decodeRetValue.nextItemIndex = decodeRetValue2.nextItemIndex;
        decodeRetValue.itemLength = decodeRetValue2.itemLength;
        switch (decodeRetValue2.syntax) {
            case 5: {
                decodeRetValue.suffix = ".0";
                decodeRetValue.numberIndexes = 1;
                break;
            }
            case 48: {
                n = decodeRetValue2.itemDataIndex;
                int n2 = decodeRetValue2.itemDataLength;
                while (n2 > 0) {
                    decodeRetValue2 = this.decodeItem(n, 2);
                    n2 -= decodeRetValue2.itemLength;
                    n = decodeRetValue2.nextItemIndex;
                    ++decodeRetValue.numberIndexes;
                    int n3 = RowMultSstDecoder.computeIntegerValue(this.values, decodeRetValue2.itemDataIndex, decodeRetValue2.itemDataLength);
                    this.info.add(this.indexesIds[decodeRetValue.numberIndexes - 1], new Integer(n3));
                    decodeRetValue.suffix = String.valueOf(decodeRetValue.suffix) + "." + n3;
                }
                break;
            }
            default: {
                throw new DecoderException("Suffix with unsupported syntax: " + decodeRetValue2.syntax);
            }
        }
        if (RAS.isEnabled(4, 1015)) {
            RAS.trace(4, 1015, this, string, "Suffix-> " + decodeRetValue.suffix);
        }
        return decodeRetValue;
    }

    public static int computeIntegerValue(byte[] byArray, int n, int n2) {
        int n3 = 0;
        n2 += n;
        int n4 = n;
        while (n4 < n2) {
            n3 = n3 << 8 | byArray[n4] & 0xFF;
            ++n4;
        }
        return n3;
    }

    public static String convertAsn1ObjectIdToDecimalString(byte[] byArray, int n, int n2) {
        String string = "convertAsn1ObjectIdToDecimalString";
        int n3 = byArray[n] & 0xFF;
        ++n;
        String string2 = String.valueOf(n3 / 40) + "." + n3 % 40;
        int n4 = 1;
        int n5 = 0;
        while (n4 < n2) {
            n5 = 0;
            n3 = byArray[n] & 0xFF;
            while ((n3 & 0x80) != 0) {
                n5 = n5 << 7 | (n3 &= 0xFFFFFF7F) & 0xFF;
                ++n4;
                n3 = byArray[++n] & 0xFF;
            }
            n5 = n5 << 7 | n3 & 0xFF;
            string2 = String.valueOf(string2) + "." + n5;
            ++n4;
            ++n;
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String[][] stringArrayArray = new String[][]{{"Panel.ModDescr", DS_STR}, {"Panel.ModVersion", DS_STR}, {"Spec.OcRCTL8000ModBootVersion", DS_STR}, {"Spec.A4FB100MICModBootVersion", DS_STR}, {"Spec.A12MB25TPModBootVersion", DS_STR}, {"Spec.A2MB155ModBootVersion", DS_STR}, {"Spec.A4FB100SCModBootVersion", DS_STR}, {"Spec.ACARModPartNum", DS_STR}, {"Spec.ACARModEng1Description", DS_STR}, {"Spec.ACARModEng1ModelNum", DS_STR}, {"Spec.ACARModEng1PartNum", DS_STR}, {"Spec.ACARModEng1OPSWVersion", DS_STR}, {"Spec.ACARModEng1BootVersion", DS_STR}, {"Spec.ACARModEng1IpAddr", IP_STR}, {"Spec.ACARModEng1SubnetMask", IP_STR}, {"Spec.ACARModEng1IpDefGtwy", IP_STR}, {"Spec.ACARModEng2Description", DS_STR}, {"Spec.ACARModEng2ModelNum", DS_STR}, {"Spec.ACARModEng2PartNum", DS_STR}, {"Spec.ACARModEng2OPSWVersion", DS_STR}, {"Spec.ACARModEng2BootVersion", DS_STR}, {"Spec.ACARModEng2IpAddr", IP_STR}, {"Spec.ACARModEng2SubnetMask", IP_STR}, {"Spec.ACARModEng2IpDefGtwy", IP_STR}, {"Spec.ACARCAPortIpAddr", IP_STR}, {"Spec.ACARCAPortSubnetMask", IP_STR}, {"Spec.A2MB1553PModBootVersion", DS_STR}, {"Spec.A4p115CUSTOMModBootVersion", DS_STR}, {"Spec.Oc64nnM4p155MMFModBootVersion", DS_STR}, {"Spec.A8265CPSWModBootVersion", DS_STR}, {"Spec.A8265CPSWModDefaultGateway", IP_STR}, {"Spec.A8265CPSWPortIpAddress", IP_STR}, {"Spec.A8265CPSWPortSubnetMask", IP_STR}, {"Spec.Oc64nnMCPSWENHANCEDModBootVersion", DS_STR}, {"Spec.Oc64nnMCPSWENHANCEDModDefaultGateway", IP_STR}, {"Spec.Oc64nnMCPSWENHANCEDPortIpAddress", IP_STR}, {"Spec.Oc64nnMCPSWENHANCEDPortSubnetMask", IP_STR}};
        int n = 0;
        while (n < stringArrayArray.length) {
            mappingTable.put(stringArrayArray[n][0], stringArrayArray[n][1]);
            ++n;
        }
    }

    private class DecodeRetValue {
        public int itemLength;
        public int itemDataLength;
        public int itemDataIndex;
        public int nextItemIndex;
        public String suffix = "";
        public int numberIndexes;
        public int syntax = 0;

        public final String toString() {
            return "il = " + this.itemLength + " idl = " + this.itemDataLength + " idi = " + this.itemDataIndex + " nii = " + this.nextItemIndex + " suf = " + this.suffix + " nind = " + this.numberIndexes + " syn = " + this.syntax;
        }

        DecodeRetValue() {
            RowMultSstDecoder.this = RowMultSstDecoder.this;
        }
    }
}

